/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioResourceAssignment;
import filenet.sim.api.VWScenarioResourceDefinition;
import filenet.sim.api.VWScenarioRoleAssignment;
import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMResourceAssignmentWrapper;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMSelectedResourcesTableModel;
import filenet.vw.base.VWDebug;
import java.util.Enumeration;
import java.util.Hashtable;

class VWSIMAssignedShiftsTableModel
extends VWSIMSelectedResourcesTableModel {
    private VWScenarioResourceDefinition m_resourceDef = null;

    public VWSIMAssignedShiftsTableModel(VWSIMPropertyData propertyData) {
        super(propertyData);
    }

    public void reinitialize(VWScenarioShiftDefinition shiftDef) throws Exception {
        throw new Exception("Not supported!");
    }

    public void reinitialize(VWScenarioResourceDefinition resourceDef) {
        try {
            VWScenarioResourceAssignment[] resourceAssignments;
            this.m_rowData.removeAllElements();
            this.m_resourceDef = resourceDef;
            if (resourceDef != null && (resourceAssignments = resourceDef.getResourceAssignments()) != null) {
                for (int i = 0; i < resourceAssignments.length; ++i) {
                    VWScenarioRoleAssignment roleAssignment = resourceAssignments[i].getRole();
                    VWScenarioShiftDefinition shiftDef = roleAssignment.getShift();
                    this.m_rowData.addElement(new VWSIMResourceAssignmentWrapper(shiftDef, roleAssignment, resourceAssignments[i], 0));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.sortRowData();
    }

    public void deleteItem(int nRowIndex) throws Exception {
        VWSIMResourceAssignmentWrapper resAssignment = this.getItemAt(nRowIndex);
        if (resAssignment != null) {
            resAssignment.delete();
            this.m_rowData.removeElementAt(nRowIndex);
            this.fireTableRowsDeleted(nRowIndex, nRowIndex);
            this.notifyPropertyListeners(resAssignment);
        }
    }

    public String[] getSelectedResourceNames() throws Exception {
        throw new Exception("Not supported!");
    }

    public String[] getSelectedShiftNames() {
        if (this.m_rowData != null) {
            VWSIMResourceAssignmentWrapper resAssignment = null;
            String[] names = new String[this.m_rowData.size()];
            for (int i = 0; i < this.m_rowData.size(); ++i) {
                resAssignment = (VWSIMResourceAssignmentWrapper)this.m_rowData.elementAt(i);
                names[i] = resAssignment.getShiftName();
            }
            return names;
        }
        return null;
    }

    public void updateResourceSelection(String[] selectedResourceNames) throws Exception {
        throw new Exception("Not supported!");
    }

    public void updateAssignedShifts(String[] assignedShiftNames) throws Exception {
        Hashtable<String, String> selectedNames = new Hashtable<String, String>();
        if (assignedShiftNames != null) {
            for (int i = 0; i < assignedShiftNames.length; ++i) {
                selectedNames.put(assignedShiftNames[i], "");
            }
        }
        VWSIMResourceAssignmentWrapper resAssignment = null;
        for (int i = this.m_rowData.size() - 1; i >= 0; --i) {
            resAssignment = (VWSIMResourceAssignmentWrapper)this.m_rowData.elementAt(i);
            if (selectedNames.containsKey(resAssignment.getShiftName())) {
                selectedNames.remove(resAssignment.getShiftName());
                continue;
            }
            this.deleteItem(i);
        }
        Enumeration newNameslist = selectedNames.keys();
        if (newNameslist != null && this.m_resourceDef != null) {
            while (newNameslist.hasMoreElements()) {
                VWScenarioShiftDefinition shiftDef = this.m_propertyData.getScenarioDefinition().getShift((String)newNameslist.nextElement());
                VWScenarioRoleAssignment roleAssignment = this.m_propertyData.getAvailableRoleAssignment(shiftDef);
                VWScenarioResourceAssignment resourceAssignment = roleAssignment.createResourceAssignment(this.m_resourceDef.getName(), Float.parseFloat("1.0"));
                VWSIMResourceAssignmentWrapper resAssignmentWrapper = new VWSIMResourceAssignmentWrapper(shiftDef, roleAssignment, resourceAssignment, 0);
                this.m_rowData.addElement(resAssignmentWrapper);
                this.notifyPropertyListeners(resAssignmentWrapper);
            }
        }
        this.sortRowData();
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWSIMResourceAssignmentWrapper resAssignment = this.getItemAt(nRowIndex);
            if (resAssignment == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    return resAssignment.getShiftName();
                }
                case 1: {
                    return resAssignment.getRoleName();
                }
                case 2: {
                    return resAssignment.getPerformance();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    protected void notifyPropertyListeners(VWSIMResourceAssignmentWrapper resAssignment) {
        this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 123, resAssignment.getShiftName());
    }
}

